# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Rounds (1-3): Cooperate unconditionally
    if current_round <= 3:
        return "C"
    
    # Mid Rounds (4-7): Cooperate if opponent has cooperated so far, else tit-for-tat
    if 4 <= current_round <= 7:
        if "D" in opp_history:
            return opp_history[-1]
        else:
            return "C"
    
    # Final Rounds (8-10): Cooperate if opponent has always cooperated, else defect
    if current_round >= 8:
        if "D" in opp_history:
            return "D"
        else:
            return "C"
    
    # Default fallback (should not reach here)
    return "C"